#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#define M 20
struct binNode {
   binNode *left;
   binNode *right;
   binNode *father;
   int freq;
   char sym;
};
struct queue{
   queue *next;
   int info;
   char sym;
};
struct stack {
    int myTop;
    binNode *item[M];
};
void pqInsert(queue **pq, int num, char symbol);
void qremove(queue **pq, int *num, char *symbol);
void maketree(binNode **, int x, int y, char, char);
int  empty(stack *s);
void printCode(binNode *tree);
int  main()
{
   binNode *root = NULL;
   char symbol1, symbol2, str[5];
   int n, fr, x, y, i;
   queue *pq;
   clrscr();
   //create head node
   pq = (queue *)malloc(sizeof(struct queue));
   pq -> next = NULL;
   pq -> info = 0;
   printf("Enter number of symbols:");
   gets(str);
   n = atoi(str);
   for(i = 0; i < n; i ++)
   {
      printf("Enter symbol:");
      symbol1 = getche();
      printf(" Enter frequency:");
      gets(str);
      fr = atoi(str);
      pqInsert(&pq, fr, symbol1);
   }
   while(pq -> info > 1)
   {
       qremove(&pq, &x, &symbol1);
       qremove(&pq, &y, &symbol2);
       maketree(&root, x, y, symbol1, symbol2);
       pqInsert(&pq, x + y, '*');
   }
   printCode(root);
   getch();
   return 0;
}

//*************
void pqInsert(queue **pq, int num, char symbol)
{
     queue *q, *h, *p;
     q = (queue *)malloc(sizeof(struct queue));
     q -> next = NULL;
     q -> info = num;
     q -> sym = symbol;
     p = *pq;
     h = (*pq) -> next;
    while(h != NULL)
    {
	    if(q -> info > h -> info)
	     {
		p = h;
		h = h -> next;
	     }
	     else
		break;
    }//end of while
    q -> next = h;
    p -> next = q;
    (*pq) -> info ++;
}
//****************
void qremove(queue **pq, int *num, char *symbol)
{
   queue *p;
   if((*pq) -> info > 0)
   {
      ((*pq) -> info) --;
      p = (*pq) -> next;
      *num = (*pq) -> next -> info;
      *symbol = (*pq) -> next -> sym;
      (*pq) -> next = p ->next;
      free(p);
   }
}
//*******************
void maketree(binNode **root, int x, int y, char symbol1, char symbol2)
{
   binNode *p1, *p2, *p;
   p1 = (binNode *)malloc(sizeof(struct binNode));
   p2 = (binNode *)malloc(sizeof(struct binNode));
   p =  (binNode *)malloc(sizeof(struct binNode));
   p ->  freq = x + y;
   p1 -> freq = x;
   p1 -> sym = symbol1;
   p1 -> left = p1 -> right = NULL;
   p2 -> freq = y;
   p2 -> sym = symbol2;
   p2 -> left = p2 -> right = NULL;
   p ->  left = p1;
   p ->  right = p2;
   p ->  father = NULL;
   p1 -> father = p2 -> father = p;
   if(*root == NULL)
      *root = p;
   else
   {
      if(p1 -> freq == (*root) -> freq)
      {
	 p1 -> left = (*root) -> left;
	 p1 -> right = (*root) -> right;
	 p1 -> left -> father = p1 -> right -> father = p1;
	 free(*root);
	 *root = p;
      }
      else
      {
	 p2 -> left = (*root) -> left;
	 p2 -> right = (*root) -> right;
	 p2 -> left -> father = p2 -> right -> father = p2;
	 free(*root);
	 *root = p;
      }
   }
}
//****************
void printCode(binNode *tree)
{
  int code [M], k, j;
  binNode *p1, *q, *p = tree;
  stack s;
  s.myTop = -1;
  printf("Generated code is:\n");
  do
  {
     // travel down left branches as far as possible
     //saving pointers to nodes passed
     while(p != NULL)
     {
	 s.item[++(s.myTop)] = p; //push to stack
	 p = p -> left;
     }
     // check if finished
     if(!empty(&s))
     {
       //at this point the left subtree is empty
	 p = s.item[(s.myTop) --];  //pop from stack
	 if(p -> right == NULL)  //p is leaf
	 {      //traverae tree up to generate code
		  k = M - 1;
		  p1 = p;
		  while(p1 !=  NULL)
		  {
		       q = p1 -> father;
		       if(q -> left == p1)
				code[k--] = 1;
			else
				code[k--] = 0;
			p1 = q;
		   }
		   printf("%c = ", p -> sym);
		   for(j = k + 2; j < M; j ++)
			printf("%d", code[j]);
		   printf("\n");
	 }
	 p = p -> right;   //traverse right subtree
     }
  } while(!empty(&s) || p != NULL);
} //end of printCode
//***************
int empty(stack *s)
{
   if(s -> myTop == -1)
      return 1;
   else
      return 0;
}
